"use strict";(globalThis.webpackChunk_plex_client_qt=globalThis.webpackChunk_plex_client_qt||[]).push([["packages_visualizer_shaders_eclipse_glsl"],{65993:n=>{n.exports="// credit: https://www.shadertoy.com/view/4tGXzt\n\n#define BEATMOVE 1\n\nprecision mediump float;\n\nuniform float uTime;\nuniform vec2 uResolution;\nvarying vec2 vTextureCoord;\nvarying vec4 vColor;\nuniform sampler2D uSampler;\nuniform sampler2D uSampler2;\n\nconst float FREQ_RANGE = 64.0;\nconst float PI = 3.1415;\nconst float RADIUS = 0.35;\nconst float BRIGHTNESS = 0.2;\nconst float SPEED = 0.6;\n\nvec2 rotate(vec2 s, float th)\n{\n  return mat2(cos(th), sin(th), -sin(th), cos(th)) * s;\n}\n\n//convert HSV to RGB\nvec3 hsv2rgb(vec3 c){\n    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\n    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\n    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\n\nfloat luma(vec3 color) {\n  return dot(color, vec3(0.299, 0.587, 0.114));\n}\n\nfloat getfrequency(float x) {\n  return texture2D(uSampler, vec2(floor(x * FREQ_RANGE + 1.0) / FREQ_RANGE, 0.0)).x + 0.06;\n}\n\nfloat getfrequency_smooth(float x) {\n  float index = floor(x * FREQ_RANGE) / FREQ_RANGE;\n    float next = floor(x * FREQ_RANGE + 1.0) / FREQ_RANGE;\n  return mix(getfrequency(index), getfrequency(next), smoothstep(0.0, 1.0, fract(x * FREQ_RANGE)));\n}\n\nvec3 doHalo(vec2 fragment, float radius) {\n  float dist = length(fragment);\n  float ring = 1.0 / (abs(dist - radius) + 0.005);\n\n  float b = dist < radius ? BRIGHTNESS * 0.6 : BRIGHTNESS;\n\n  vec3 col = vec3(0.0);\n\n  float angle = atan(fragment.x, fragment.y);\n  col += hsv2rgb( vec3( ( angle + uTime * 0.25 ) / (PI * 2.0), 0.6, 0.5 ) ) * ring * b;\n\n  float frequency = max(getfrequency_smooth(abs(angle / PI)) - 0.02, 0.0);\n  col *= frequency * 0.5;\n\n  // Black halo\n  col *= smoothstep(radius * 0.86, radius, dist);\n\n  return col;\n}\n\nvec3 useLogo(vec2 fragment, float radius) {\n  float dist = length(fragment);\n  vec4 col = vec4(0.0);\n\n  if (dist < radius) {\n    vec2 uv = fragment * 1.4 + 0.5;\n    col = texture2D(uSampler2, uv);\n  }\n\n  return col.rgb;\n}\n\nvec3 doLine(vec2 fragment, float radius, float x) {\n  vec3 col = hsv2rgb(vec3(x * 0.23 + uTime * 0.12, 1.0, 1.0));\n\n  float freq = abs(fragment.x * 0.5);\n\n  col *= (1.0 / abs(fragment.y)) * BRIGHTNESS * getfrequency(freq);\n  col = col * smoothstep(radius, radius * 1.8, abs(fragment.x));\n\n  return col;\n}\n\n\nvoid main( void ) {\n  vec2 fragPos = vec2(vTextureCoord.x, 1.0 - vTextureCoord.y);\n\n  fragPos = (fragPos - 0.5) * 2.0;\n  fragPos.x *= uResolution.x / uResolution.y;\n\n  vec3 color = vec3(0.0134, 0.052, 0.1);\n\n  color += useLogo(fragPos, RADIUS);\n  color += doHalo(fragPos, RADIUS);\n  color += max(luma(color) - 1.0, 0.0);\n\n  gl_FragColor = vec4(color, 1.0);\n}\n"}}]);